import MQTT from "./MQTT"; // Kicks off MQTT listener
import Database from "./Database"; // Assuming you have a Database class for DB connection
import { mqttTopic } from "./config";

const mqtt_instance = MQTT.getInstance();
const db = Database.getInstance();

function start() {
  mqtt_instance.Subscribe(mqttTopic);
  mqtt_instance.AddOnMessageListener(OnMessage);
}

async function OnMessage(topic: string, message: Buffer) {
  const data = JSON.parse(message.toString());
  const SQL = `
    INSERT INTO sensor_data (timestamp, machine_id, sensor_type, value, unit) 
    VALUES ($1, $2, $3, $4, $5)`;
  const PARAMS = [
    data.timestamp,
    Number(data.machineId),
    data.sensorType,
    data.value,
    data.unit,
  ];
  try {
    await db.query(SQL, PARAMS);
  } catch (error) {
    console.error("Error inserting data into DB:", error);
  }
}

start();

process.on("SIGINT", async () => {
  mqtt_instance.close();
  db.close();
  process.exit();
});
